#include <Origin.h>
#include <Dialog.h>


//#include "resource.h"
#define IDD_DIALOG                      101
#define IDC_CHECK                       1000
#define IDC_EDIT                        1001
#define IDC_COMBO                       1002


class MyCustomXFDlg : public Dialog
{
public:
	MyCustomXFDlg() : Dialog(IDD_DIALOG, "XFCustom")
	{
	}

	int MyDoModal(HWND hWnd, TreeNode tn)
	{
		m_tn = tn;

		InitMsgMap();
		return DoModal(hWnd, DLG_TITLE_TO_HAVE_PAGE_NAME);
	}

	EVENTS_BEGIN
		ON_INIT(Init)
		ON_OK(OnOk)
		ON_CANCEL(OnCancel)
		ON_DESTROY(OnDestroy)
	EVENTS_END

	BOOL Init()
	{
		m_combo = GetDlgItem(IDC_COMBO);
		m_check = GetDlgItem(IDC_CHECK);
		m_edit = GetDlgItem(IDC_EDIT);

		UpdateData(); // tree to dlg
		//out_tree(m_tn);
		return TRUE;
	}

	BOOL OnOk()
	{
		UpdateData(false); // dlg to tree
		return TRUE;
	}

	BOOL OnCancel()
	{
		return TRUE;
	}

	BOOL OnDestroy()
	{
		return TRUE;
	}

	void UpdateData(bool bTreeToDlg = true)
	{
		int i;
		string str;

		if( bTreeToDlg )
		{
			m_tn.GetValue(i, "color");
			m_combo.SetCurSel(i - 1);

			m_tn.GetValue(i, "chk");
			m_check.Check = i;

			m_tn.GetValue(str, "edit");
			m_edit.Text = str;
		}
		else // dlg to tree
		{
			m_tn.SetValue(m_combo.GetCurSel() + 1, "color");
			m_tn.SetValue(m_check.Check, "chk");
			m_tn.SetValue(m_edit.Text, "edit");
		}
	}

protected:
	ComboBox m_combo;
	Button m_check;
	Edit m_edit;

	TreeNode m_tn;

};
